package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait FileExistsBehavior {
  def unwrap
      : software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior
}
object FileExistsBehavior {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior
  ): zio.aws.codedeploy.model.FileExistsBehavior = value match {
    case software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior.DISALLOW =>
      val r = DISALLOW
      r
    case software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior.OVERWRITE =>
      val r = OVERWRITE
      r
    case software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior.RETAIN =>
      val r = RETAIN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.FileExistsBehavior {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior =
      software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object DISALLOW extends zio.aws.codedeploy.model.FileExistsBehavior {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior =
      software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior.DISALLOW
  }
  case object OVERWRITE extends zio.aws.codedeploy.model.FileExistsBehavior {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior =
      software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior.OVERWRITE
  }
  case object RETAIN extends zio.aws.codedeploy.model.FileExistsBehavior {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior =
      software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior.RETAIN
  }
}
