package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait AutoRollbackEvent {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent
}
object AutoRollbackEvent {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent
  ): zio.aws.codedeploy.model.AutoRollbackEvent = value match {
    case software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent.DEPLOYMENT_FAILURE =>
      val r = DEPLOYMENT_FAILURE
      r
    case software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent.DEPLOYMENT_STOP_ON_ALARM =>
      val r = DEPLOYMENT_STOP_ON_ALARM
      r
    case software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent.DEPLOYMENT_STOP_ON_REQUEST =>
      val r = DEPLOYMENT_STOP_ON_REQUEST
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.AutoRollbackEvent {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent =
      software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent.UNKNOWN_TO_SDK_VERSION
  }
  case object DEPLOYMENT_FAILURE
      extends zio.aws.codedeploy.model.AutoRollbackEvent {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent =
      software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent.DEPLOYMENT_FAILURE
  }
  case object DEPLOYMENT_STOP_ON_ALARM
      extends zio.aws.codedeploy.model.AutoRollbackEvent {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent =
      software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent.DEPLOYMENT_STOP_ON_ALARM
  }
  case object DEPLOYMENT_STOP_ON_REQUEST
      extends zio.aws.codedeploy.model.AutoRollbackEvent {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent =
      software.amazon.awssdk.services.codedeploy.model.AutoRollbackEvent.DEPLOYMENT_STOP_ON_REQUEST
  }
}
