package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetOnPremisesInstancesResponse(
    instanceInfos: Optional[Iterable[zio.aws.codedeploy.model.InstanceInfo]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesResponse = {
    import BatchGetOnPremisesInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesResponse
      .builder()
      .optionallyWith(
        instanceInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceInfos)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.BatchGetOnPremisesInstancesResponse.ReadOnly =
    zio.aws.codedeploy.model.BatchGetOnPremisesInstancesResponse
      .wrap(buildAwsValue())
}
object BatchGetOnPremisesInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codedeploy.model.BatchGetOnPremisesInstancesResponse =
      zio.aws.codedeploy.model.BatchGetOnPremisesInstancesResponse(
        instanceInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def instanceInfos
        : Optional[List[zio.aws.codedeploy.model.InstanceInfo.ReadOnly]]
    def getInstanceInfos: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.InstanceInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceInfos", instanceInfos)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesResponse
  ) extends zio.aws.codedeploy.model.BatchGetOnPremisesInstancesResponse.ReadOnly {
    override val instanceInfos
        : Optional[List[zio.aws.codedeploy.model.InstanceInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceInfos())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.InstanceInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetOnPremisesInstancesResponse
  ): zio.aws.codedeploy.model.BatchGetOnPremisesInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
