package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RevisionInfo(
    revisionLocation: Optional[zio.aws.codedeploy.model.RevisionLocation] =
      Optional.Absent,
    genericRevisionInfo: Optional[
      zio.aws.codedeploy.model.GenericRevisionInfo
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.RevisionInfo = {
    import RevisionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.RevisionInfo
      .builder()
      .optionallyWith(revisionLocation.map(value => value.buildAwsValue()))(
        _.revisionLocation
      )
      .optionallyWith(genericRevisionInfo.map(value => value.buildAwsValue()))(
        _.genericRevisionInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.RevisionInfo.ReadOnly =
    zio.aws.codedeploy.model.RevisionInfo.wrap(buildAwsValue())
}
object RevisionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.RevisionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.RevisionInfo =
      zio.aws.codedeploy.model.RevisionInfo(
        revisionLocation.map(value => value.asEditable),
        genericRevisionInfo.map(value => value.asEditable)
      )
    def revisionLocation
        : Optional[zio.aws.codedeploy.model.RevisionLocation.ReadOnly]
    def genericRevisionInfo
        : Optional[zio.aws.codedeploy.model.GenericRevisionInfo.ReadOnly]
    def getRevisionLocation: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.RevisionLocation.ReadOnly
    ] = AwsError.unwrapOptionField("revisionLocation", revisionLocation)
    def getGenericRevisionInfo: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.GenericRevisionInfo.ReadOnly
    ] = AwsError.unwrapOptionField("genericRevisionInfo", genericRevisionInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.RevisionInfo
  ) extends zio.aws.codedeploy.model.RevisionInfo.ReadOnly {
    override val revisionLocation
        : Optional[zio.aws.codedeploy.model.RevisionLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revisionLocation())
        .map(value => zio.aws.codedeploy.model.RevisionLocation.wrap(value))
    override val genericRevisionInfo
        : Optional[zio.aws.codedeploy.model.GenericRevisionInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.genericRevisionInfo())
        .map(value => zio.aws.codedeploy.model.GenericRevisionInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.RevisionInfo
  ): zio.aws.codedeploy.model.RevisionInfo.ReadOnly = new Wrapper(impl)
}
