package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.InstanceName
import scala.jdk.CollectionConverters.*
final case class GetOnPremisesInstanceRequest(instanceName: InstanceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest = {
    import GetOnPremisesInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest
      .builder()
      .instanceName(InstanceName.unwrap(instanceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.GetOnPremisesInstanceRequest.ReadOnly =
    zio.aws.codedeploy.model.GetOnPremisesInstanceRequest.wrap(buildAwsValue())
}
object GetOnPremisesInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetOnPremisesInstanceRequest =
      zio.aws.codedeploy.model.GetOnPremisesInstanceRequest(instanceName)
    def instanceName: InstanceName
    def getInstanceName: ZIO[Any, Nothing, InstanceName] =
      ZIO.succeed(instanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest
  ) extends zio.aws.codedeploy.model.GetOnPremisesInstanceRequest.ReadOnly {
    override val instanceName: InstanceName =
      zio.aws.codedeploy.model.primitives.InstanceName(impl.instanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceRequest
  ): zio.aws.codedeploy.model.GetOnPremisesInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
