package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetDeploymentTargetsResponse(
    deploymentTargets: Optional[
      Iterable[zio.aws.codedeploy.model.DeploymentTarget]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsResponse = {
    import BatchGetDeploymentTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsResponse
      .builder()
      .optionallyWith(
        deploymentTargets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deploymentTargets)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.BatchGetDeploymentTargetsResponse.ReadOnly =
    zio.aws.codedeploy.model.BatchGetDeploymentTargetsResponse
      .wrap(buildAwsValue())
}
object BatchGetDeploymentTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.BatchGetDeploymentTargetsResponse =
      zio.aws.codedeploy.model.BatchGetDeploymentTargetsResponse(
        deploymentTargets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deploymentTargets
        : Optional[List[zio.aws.codedeploy.model.DeploymentTarget.ReadOnly]]
    def getDeploymentTargets: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.DeploymentTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("deploymentTargets", deploymentTargets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsResponse
  ) extends zio.aws.codedeploy.model.BatchGetDeploymentTargetsResponse.ReadOnly {
    override val deploymentTargets
        : Optional[List[zio.aws.codedeploy.model.DeploymentTarget.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentTargets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.DeploymentTarget.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsResponse
  ): zio.aws.codedeploy.model.BatchGetDeploymentTargetsResponse.ReadOnly =
    new Wrapper(impl)
}
