package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.Message
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StopDeploymentResponse(
    status: Optional[zio.aws.codedeploy.model.StopStatus] = Optional.Absent,
    statusMessage: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.StopDeploymentResponse = {
    import StopDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.StopDeploymentResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.StopDeploymentResponse.ReadOnly =
    zio.aws.codedeploy.model.StopDeploymentResponse.wrap(buildAwsValue())
}
object StopDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.StopDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.StopDeploymentResponse =
      zio.aws.codedeploy.model.StopDeploymentResponse(
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def status: Optional[zio.aws.codedeploy.model.StopStatus]
    def statusMessage: Optional[Message]
    def getStatus: ZIO[Any, AwsError, zio.aws.codedeploy.model.StopStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.StopDeploymentResponse
  ) extends zio.aws.codedeploy.model.StopDeploymentResponse.ReadOnly {
    override val status: Optional[zio.aws.codedeploy.model.StopStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codedeploy.model.StopStatus.wrap(value))
    override val statusMessage: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.codedeploy.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.StopDeploymentResponse
  ): zio.aws.codedeploy.model.StopDeploymentResponse.ReadOnly = new Wrapper(
    impl
  )
}
