package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GreenFleetProvisioningOption(
    action: Optional[zio.aws.codedeploy.model.GreenFleetProvisioningAction] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GreenFleetProvisioningOption = {
    import GreenFleetProvisioningOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GreenFleetProvisioningOption
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.GreenFleetProvisioningOption.ReadOnly =
    zio.aws.codedeploy.model.GreenFleetProvisioningOption.wrap(buildAwsValue())
}
object GreenFleetProvisioningOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GreenFleetProvisioningOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GreenFleetProvisioningOption =
      zio.aws.codedeploy.model
        .GreenFleetProvisioningOption(action.map(value => value))
    def action: Optional[zio.aws.codedeploy.model.GreenFleetProvisioningAction]
    def getAction: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.GreenFleetProvisioningAction
    ] = AwsError.unwrapOptionField("action", action)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GreenFleetProvisioningOption
  ) extends zio.aws.codedeploy.model.GreenFleetProvisioningOption.ReadOnly {
    override val action
        : Optional[zio.aws.codedeploy.model.GreenFleetProvisioningAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value =>
          zio.aws.codedeploy.model.GreenFleetProvisioningAction.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GreenFleetProvisioningOption
  ): zio.aws.codedeploy.model.GreenFleetProvisioningOption.ReadOnly =
    new Wrapper(impl)
}
