package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{Value, Key}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Tag(
    key: Optional[Key] = Optional.Absent,
    value: Optional[Value] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.codedeploy.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.Tag
      .builder()
      .optionallyWith(key.map(value => Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        value.map(value => Value.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.Tag.ReadOnly =
    zio.aws.codedeploy.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codedeploy.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.Tag = zio.aws.codedeploy.model
      .Tag(key.map(value => value), value.map(value => value))
    def key: Optional[Key]
    def value: Optional[Value]
    def getKey: ZIO[Any, AwsError, Key] = AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, Value] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.Tag
  ) extends zio.aws.codedeploy.model.Tag.ReadOnly {
    override val key: Optional[Key] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.codedeploy.model.primitives.Key(value))
    override val value: Optional[Value] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.codedeploy.model.primitives.Value(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.Tag
  ): zio.aws.codedeploy.model.Tag.ReadOnly = new Wrapper(impl)
}
