package zio.aws.codedeploy.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.codedeploy.model.primitives.{
  Timestamp,
  DeploymentGroupName,
  Description
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GenericRevisionInfo(
    description: Optional[Description] = Optional.Absent,
    deploymentGroups: Optional[Iterable[DeploymentGroupName]] = Optional.Absent,
    firstUsedTime: Optional[Timestamp] = Optional.Absent,
    lastUsedTime: Optional[Timestamp] = Optional.Absent,
    registerTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GenericRevisionInfo = {
    import GenericRevisionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GenericRevisionInfo
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        deploymentGroups.map(value =>
          value.map { item =>
            DeploymentGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deploymentGroups)
      .optionallyWith(
        firstUsedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.firstUsedTime)
      .optionallyWith(
        lastUsedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUsedTime)
      .optionallyWith(
        registerTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.registerTime)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.GenericRevisionInfo.ReadOnly =
    zio.aws.codedeploy.model.GenericRevisionInfo.wrap(buildAwsValue())
}
object GenericRevisionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GenericRevisionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GenericRevisionInfo =
      zio.aws.codedeploy.model.GenericRevisionInfo(
        description.map(value => value),
        deploymentGroups.map(value => value),
        firstUsedTime.map(value => value),
        lastUsedTime.map(value => value),
        registerTime.map(value => value)
      )
    def description: Optional[Description]
    def deploymentGroups: Optional[List[DeploymentGroupName]]
    def firstUsedTime: Optional[Timestamp]
    def lastUsedTime: Optional[Timestamp]
    def registerTime: Optional[Timestamp]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDeploymentGroups: ZIO[Any, AwsError, List[DeploymentGroupName]] =
      AwsError.unwrapOptionField("deploymentGroups", deploymentGroups)
    def getFirstUsedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("firstUsedTime", firstUsedTime)
    def getLastUsedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUsedTime", lastUsedTime)
    def getRegisterTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("registerTime", registerTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GenericRevisionInfo
  ) extends zio.aws.codedeploy.model.GenericRevisionInfo.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.codedeploy.model.primitives.Description(value))
    override val deploymentGroups: Optional[List[DeploymentGroupName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.primitives.DeploymentGroupName(item)
          }.toList
        )
    override val firstUsedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.firstUsedTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val lastUsedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUsedTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val registerTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.registerTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GenericRevisionInfo
  ): zio.aws.codedeploy.model.GenericRevisionInfo.ReadOnly = new Wrapper(impl)
}
