package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  DeploymentGroupName,
  DeploymentConfigName,
  ApplicationName,
  AutoScalingGroupName,
  Role
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDeploymentGroupRequest(
    applicationName: ApplicationName,
    currentDeploymentGroupName: DeploymentGroupName,
    newDeploymentGroupName: Optional[DeploymentGroupName] = Optional.Absent,
    deploymentConfigName: Optional[DeploymentConfigName] = Optional.Absent,
    ec2TagFilters: Optional[Iterable[zio.aws.codedeploy.model.EC2TagFilter]] =
      Optional.Absent,
    onPremisesInstanceTagFilters: Optional[
      Iterable[zio.aws.codedeploy.model.TagFilter]
    ] = Optional.Absent,
    autoScalingGroups: Optional[Iterable[AutoScalingGroupName]] =
      Optional.Absent,
    serviceRoleArn: Optional[Role] = Optional.Absent,
    triggerConfigurations: Optional[
      Iterable[zio.aws.codedeploy.model.TriggerConfig]
    ] = Optional.Absent,
    alarmConfiguration: Optional[zio.aws.codedeploy.model.AlarmConfiguration] =
      Optional.Absent,
    autoRollbackConfiguration: Optional[
      zio.aws.codedeploy.model.AutoRollbackConfiguration
    ] = Optional.Absent,
    outdatedInstancesStrategy: Optional[
      zio.aws.codedeploy.model.OutdatedInstancesStrategy
    ] = Optional.Absent,
    deploymentStyle: Optional[zio.aws.codedeploy.model.DeploymentStyle] =
      Optional.Absent,
    blueGreenDeploymentConfiguration: Optional[
      zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration
    ] = Optional.Absent,
    loadBalancerInfo: Optional[zio.aws.codedeploy.model.LoadBalancerInfo] =
      Optional.Absent,
    ec2TagSet: Optional[zio.aws.codedeploy.model.EC2TagSet] = Optional.Absent,
    ecsServices: Optional[Iterable[zio.aws.codedeploy.model.ECSService]] =
      Optional.Absent,
    onPremisesTagSet: Optional[zio.aws.codedeploy.model.OnPremisesTagSet] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest = {
    import UpdateDeploymentGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentDeploymentGroupName(
        DeploymentGroupName.unwrap(currentDeploymentGroupName): java.lang.String
      )
      .optionallyWith(
        newDeploymentGroupName.map(value =>
          DeploymentGroupName.unwrap(value): java.lang.String
        )
      )(_.newDeploymentGroupName)
      .optionallyWith(
        deploymentConfigName.map(value =>
          DeploymentConfigName.unwrap(value): java.lang.String
        )
      )(_.deploymentConfigName)
      .optionallyWith(
        ec2TagFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ec2TagFilters)
      .optionallyWith(
        onPremisesInstanceTagFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onPremisesInstanceTagFilters)
      .optionallyWith(
        autoScalingGroups.map(value =>
          value.map { item =>
            AutoScalingGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoScalingGroups)
      .optionallyWith(
        serviceRoleArn.map(value => Role.unwrap(value): java.lang.String)
      )(_.serviceRoleArn)
      .optionallyWith(
        triggerConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.triggerConfigurations)
      .optionallyWith(alarmConfiguration.map(value => value.buildAwsValue()))(
        _.alarmConfiguration
      )
      .optionallyWith(
        autoRollbackConfiguration.map(value => value.buildAwsValue())
      )(_.autoRollbackConfiguration)
      .optionallyWith(outdatedInstancesStrategy.map(value => value.unwrap))(
        _.outdatedInstancesStrategy
      )
      .optionallyWith(deploymentStyle.map(value => value.buildAwsValue()))(
        _.deploymentStyle
      )
      .optionallyWith(
        blueGreenDeploymentConfiguration.map(value => value.buildAwsValue())
      )(_.blueGreenDeploymentConfiguration)
      .optionallyWith(loadBalancerInfo.map(value => value.buildAwsValue()))(
        _.loadBalancerInfo
      )
      .optionallyWith(ec2TagSet.map(value => value.buildAwsValue()))(
        _.ec2TagSet
      )
      .optionallyWith(
        ecsServices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ecsServices)
      .optionallyWith(onPremisesTagSet.map(value => value.buildAwsValue()))(
        _.onPremisesTagSet
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.UpdateDeploymentGroupRequest.ReadOnly =
    zio.aws.codedeploy.model.UpdateDeploymentGroupRequest.wrap(buildAwsValue())
}
object UpdateDeploymentGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.UpdateDeploymentGroupRequest =
      zio.aws.codedeploy.model.UpdateDeploymentGroupRequest(
        applicationName,
        currentDeploymentGroupName,
        newDeploymentGroupName.map(value => value),
        deploymentConfigName.map(value => value),
        ec2TagFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        onPremisesInstanceTagFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoScalingGroups.map(value => value),
        serviceRoleArn.map(value => value),
        triggerConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        alarmConfiguration.map(value => value.asEditable),
        autoRollbackConfiguration.map(value => value.asEditable),
        outdatedInstancesStrategy.map(value => value),
        deploymentStyle.map(value => value.asEditable),
        blueGreenDeploymentConfiguration.map(value => value.asEditable),
        loadBalancerInfo.map(value => value.asEditable),
        ec2TagSet.map(value => value.asEditable),
        ecsServices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        onPremisesTagSet.map(value => value.asEditable)
      )
    def applicationName: ApplicationName
    def currentDeploymentGroupName: DeploymentGroupName
    def newDeploymentGroupName: Optional[DeploymentGroupName]
    def deploymentConfigName: Optional[DeploymentConfigName]
    def ec2TagFilters
        : Optional[List[zio.aws.codedeploy.model.EC2TagFilter.ReadOnly]]
    def onPremisesInstanceTagFilters
        : Optional[List[zio.aws.codedeploy.model.TagFilter.ReadOnly]]
    def autoScalingGroups: Optional[List[AutoScalingGroupName]]
    def serviceRoleArn: Optional[Role]
    def triggerConfigurations
        : Optional[List[zio.aws.codedeploy.model.TriggerConfig.ReadOnly]]
    def alarmConfiguration
        : Optional[zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly]
    def autoRollbackConfiguration
        : Optional[zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly]
    def outdatedInstancesStrategy
        : Optional[zio.aws.codedeploy.model.OutdatedInstancesStrategy]
    def deploymentStyle
        : Optional[zio.aws.codedeploy.model.DeploymentStyle.ReadOnly]
    def blueGreenDeploymentConfiguration: Optional[
      zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.ReadOnly
    ]
    def loadBalancerInfo
        : Optional[zio.aws.codedeploy.model.LoadBalancerInfo.ReadOnly]
    def ec2TagSet: Optional[zio.aws.codedeploy.model.EC2TagSet.ReadOnly]
    def ecsServices
        : Optional[List[zio.aws.codedeploy.model.ECSService.ReadOnly]]
    def onPremisesTagSet
        : Optional[zio.aws.codedeploy.model.OnPremisesTagSet.ReadOnly]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentDeploymentGroupName: ZIO[Any, Nothing, DeploymentGroupName] =
      ZIO.succeed(currentDeploymentGroupName)
    def getNewDeploymentGroupName: ZIO[Any, AwsError, DeploymentGroupName] =
      AwsError.unwrapOptionField(
        "newDeploymentGroupName",
        newDeploymentGroupName
      )
    def getDeploymentConfigName: ZIO[Any, AwsError, DeploymentConfigName] =
      AwsError.unwrapOptionField("deploymentConfigName", deploymentConfigName)
    def getEc2TagFilters: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.EC2TagFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("ec2TagFilters", ec2TagFilters)
    def getOnPremisesInstanceTagFilters: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.TagFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "onPremisesInstanceTagFilters",
      onPremisesInstanceTagFilters
    )
    def getAutoScalingGroups: ZIO[Any, AwsError, List[AutoScalingGroupName]] =
      AwsError.unwrapOptionField("autoScalingGroups", autoScalingGroups)
    def getServiceRoleArn: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getTriggerConfigurations: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.TriggerConfig.ReadOnly
    ]] =
      AwsError.unwrapOptionField("triggerConfigurations", triggerConfigurations)
    def getAlarmConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("alarmConfiguration", alarmConfiguration)
    def getAutoRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoRollbackConfiguration",
      autoRollbackConfiguration
    )
    def getOutdatedInstancesStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.OutdatedInstancesStrategy
    ] = AwsError.unwrapOptionField(
      "outdatedInstancesStrategy",
      outdatedInstancesStrategy
    )
    def getDeploymentStyle: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.DeploymentStyle.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentStyle", deploymentStyle)
    def getBlueGreenDeploymentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "blueGreenDeploymentConfiguration",
      blueGreenDeploymentConfiguration
    )
    def getLoadBalancerInfo: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.LoadBalancerInfo.ReadOnly
    ] = AwsError.unwrapOptionField("loadBalancerInfo", loadBalancerInfo)
    def getEc2TagSet
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.EC2TagSet.ReadOnly] =
      AwsError.unwrapOptionField("ec2TagSet", ec2TagSet)
    def getEcsServices: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.ECSService.ReadOnly
    ]] = AwsError.unwrapOptionField("ecsServices", ecsServices)
    def getOnPremisesTagSet: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.OnPremisesTagSet.ReadOnly
    ] = AwsError.unwrapOptionField("onPremisesTagSet", onPremisesTagSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest
  ) extends zio.aws.codedeploy.model.UpdateDeploymentGroupRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.codedeploy.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentDeploymentGroupName: DeploymentGroupName =
      zio.aws.codedeploy.model.primitives
        .DeploymentGroupName(impl.currentDeploymentGroupName())
    override val newDeploymentGroupName: Optional[DeploymentGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newDeploymentGroupName())
        .map(value =>
          zio.aws.codedeploy.model.primitives.DeploymentGroupName(value)
        )
    override val deploymentConfigName: Optional[DeploymentConfigName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentConfigName())
        .map(value =>
          zio.aws.codedeploy.model.primitives.DeploymentConfigName(value)
        )
    override val ec2TagFilters
        : Optional[List[zio.aws.codedeploy.model.EC2TagFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2TagFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.EC2TagFilter.wrap(item)
          }.toList
        )
    override val onPremisesInstanceTagFilters
        : Optional[List[zio.aws.codedeploy.model.TagFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onPremisesInstanceTagFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.TagFilter.wrap(item)
          }.toList
        )
    override val autoScalingGroups: Optional[List[AutoScalingGroupName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.primitives.AutoScalingGroupName(item)
          }.toList
        )
    override val serviceRoleArn: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRoleArn())
      .map(value => zio.aws.codedeploy.model.primitives.Role(value))
    override val triggerConfigurations
        : Optional[List[zio.aws.codedeploy.model.TriggerConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.triggerConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.TriggerConfig.wrap(item)
          }.toList
        )
    override val alarmConfiguration
        : Optional[zio.aws.codedeploy.model.AlarmConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmConfiguration())
        .map(value => zio.aws.codedeploy.model.AlarmConfiguration.wrap(value))
    override val autoRollbackConfiguration: Optional[
      zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.autoRollbackConfiguration())
      .map(value =>
        zio.aws.codedeploy.model.AutoRollbackConfiguration.wrap(value)
      )
    override val outdatedInstancesStrategy
        : Optional[zio.aws.codedeploy.model.OutdatedInstancesStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outdatedInstancesStrategy())
        .map(value =>
          zio.aws.codedeploy.model.OutdatedInstancesStrategy.wrap(value)
        )
    override val deploymentStyle
        : Optional[zio.aws.codedeploy.model.DeploymentStyle.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStyle())
        .map(value => zio.aws.codedeploy.model.DeploymentStyle.wrap(value))
    override val blueGreenDeploymentConfiguration: Optional[
      zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blueGreenDeploymentConfiguration())
      .map(value =>
        zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.wrap(value)
      )
    override val loadBalancerInfo
        : Optional[zio.aws.codedeploy.model.LoadBalancerInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerInfo())
        .map(value => zio.aws.codedeploy.model.LoadBalancerInfo.wrap(value))
    override val ec2TagSet
        : Optional[zio.aws.codedeploy.model.EC2TagSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2TagSet())
        .map(value => zio.aws.codedeploy.model.EC2TagSet.wrap(value))
    override val ecsServices
        : Optional[List[zio.aws.codedeploy.model.ECSService.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ecsServices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.ECSService.wrap(item)
          }.toList
        )
    override val onPremisesTagSet
        : Optional[zio.aws.codedeploy.model.OnPremisesTagSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onPremisesTagSet())
        .map(value => zio.aws.codedeploy.model.OnPremisesTagSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.UpdateDeploymentGroupRequest
  ): zio.aws.codedeploy.model.UpdateDeploymentGroupRequest.ReadOnly =
    new Wrapper(impl)
}
