package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OnPremisesTagSet(
    onPremisesTagSetList: Optional[
      Iterable[Iterable[zio.aws.codedeploy.model.TagFilter]]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.OnPremisesTagSet = {
    import OnPremisesTagSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.OnPremisesTagSet
      .builder()
      .optionallyWith(
        onPremisesTagSetList.map(value =>
          value.map { item =>
            item.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.onPremisesTagSetList)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.OnPremisesTagSet.ReadOnly =
    zio.aws.codedeploy.model.OnPremisesTagSet.wrap(buildAwsValue())
}
object OnPremisesTagSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.OnPremisesTagSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.OnPremisesTagSet =
      zio.aws.codedeploy.model.OnPremisesTagSet(
        onPremisesTagSetList.map(value =>
          value.map { item =>
            item.map { item =>
              item.asEditable
            }
          }
        )
      )
    def onPremisesTagSetList
        : Optional[List[List[zio.aws.codedeploy.model.TagFilter.ReadOnly]]]
    def getOnPremisesTagSetList: ZIO[Any, AwsError, List[
      List[zio.aws.codedeploy.model.TagFilter.ReadOnly]
    ]] =
      AwsError.unwrapOptionField("onPremisesTagSetList", onPremisesTagSetList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.OnPremisesTagSet
  ) extends zio.aws.codedeploy.model.OnPremisesTagSet.ReadOnly {
    override val onPremisesTagSetList
        : Optional[List[List[zio.aws.codedeploy.model.TagFilter.ReadOnly]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onPremisesTagSetList())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              zio.aws.codedeploy.model.TagFilter.wrap(item)
            }.toList
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.OnPremisesTagSet
  ): zio.aws.codedeploy.model.OnPremisesTagSet.ReadOnly = new Wrapper(impl)
}
