package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{NextToken, InstanceName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListOnPremisesInstancesResponse(
    instanceNames: Optional[Iterable[InstanceName]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesResponse = {
    import ListOnPremisesInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesResponse
      .builder()
      .optionallyWith(
        instanceNames.map(value =>
          value.map { item =>
            InstanceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceNames)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListOnPremisesInstancesResponse.ReadOnly =
    zio.aws.codedeploy.model.ListOnPremisesInstancesResponse
      .wrap(buildAwsValue())
}
object ListOnPremisesInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListOnPremisesInstancesResponse =
      zio.aws.codedeploy.model.ListOnPremisesInstancesResponse(
        instanceNames.map(value => value),
        nextToken.map(value => value)
      )
    def instanceNames: Optional[List[InstanceName]]
    def nextToken: Optional[NextToken]
    def getInstanceNames: ZIO[Any, AwsError, List[InstanceName]] =
      AwsError.unwrapOptionField("instanceNames", instanceNames)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesResponse
  ) extends zio.aws.codedeploy.model.ListOnPremisesInstancesResponse.ReadOnly {
    override val instanceNames: Optional[List[InstanceName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.primitives.InstanceName(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesResponse
  ): zio.aws.codedeploy.model.ListOnPremisesInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
