package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.ApplicationName
import scala.jdk.CollectionConverters.*
final case class GetApplicationRequest(applicationName: ApplicationName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest = {
    import GetApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.GetApplicationRequest.ReadOnly =
    zio.aws.codedeploy.model.GetApplicationRequest.wrap(buildAwsValue())
}
object GetApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetApplicationRequest =
      zio.aws.codedeploy.model.GetApplicationRequest(applicationName)
    def applicationName: ApplicationName
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest
  ) extends zio.aws.codedeploy.model.GetApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.codedeploy.model.primitives
        .ApplicationName(impl.applicationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetApplicationRequest
  ): zio.aws.codedeploy.model.GetApplicationRequest.ReadOnly = new Wrapper(impl)
}
