package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{Description, ApplicationName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RegisterApplicationRevisionRequest(
    applicationName: ApplicationName,
    description: Optional[Description] = Optional.Absent,
    revision: zio.aws.codedeploy.model.RevisionLocation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest = {
    import RegisterApplicationRevisionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .revision(revision.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.RegisterApplicationRevisionRequest.ReadOnly =
    zio.aws.codedeploy.model.RegisterApplicationRevisionRequest
      .wrap(buildAwsValue())
}
object RegisterApplicationRevisionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codedeploy.model.RegisterApplicationRevisionRequest =
      zio.aws.codedeploy.model.RegisterApplicationRevisionRequest(
        applicationName,
        description.map(value => value),
        revision.asEditable
      )
    def applicationName: ApplicationName
    def description: Optional[Description]
    def revision: zio.aws.codedeploy.model.RevisionLocation.ReadOnly
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRevision: ZIO[
      Any,
      Nothing,
      zio.aws.codedeploy.model.RevisionLocation.ReadOnly
    ] = ZIO.succeed(revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest
  ) extends zio.aws.codedeploy.model.RegisterApplicationRevisionRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.codedeploy.model.primitives
        .ApplicationName(impl.applicationName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.codedeploy.model.primitives.Description(value))
    override val revision: zio.aws.codedeploy.model.RevisionLocation.ReadOnly =
      zio.aws.codedeploy.model.RevisionLocation.wrap(impl.revision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.RegisterApplicationRevisionRequest
  ): zio.aws.codedeploy.model.RegisterApplicationRevisionRequest.ReadOnly =
    new Wrapper(impl)
}
