package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  TrafficWeight,
  ECSTaskSetStatus,
  ECSTaskSetCount,
  ECSTaskSetIdentifier
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ECSTaskSet(
    identifer: Optional[ECSTaskSetIdentifier] = Optional.Absent,
    desiredCount: Optional[ECSTaskSetCount] = Optional.Absent,
    pendingCount: Optional[ECSTaskSetCount] = Optional.Absent,
    runningCount: Optional[ECSTaskSetCount] = Optional.Absent,
    status: Optional[ECSTaskSetStatus] = Optional.Absent,
    trafficWeight: Optional[TrafficWeight] = Optional.Absent,
    targetGroup: Optional[zio.aws.codedeploy.model.TargetGroupInfo] =
      Optional.Absent,
    taskSetLabel: Optional[zio.aws.codedeploy.model.TargetLabel] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ECSTaskSet = {
    import ECSTaskSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ECSTaskSet
      .builder()
      .optionallyWith(
        identifer.map(value =>
          ECSTaskSetIdentifier.unwrap(value): java.lang.String
        )
      )(_.identifer)
      .optionallyWith(
        desiredCount.map(value => ECSTaskSetCount.unwrap(value): java.lang.Long)
      )(_.desiredCount)
      .optionallyWith(
        pendingCount.map(value => ECSTaskSetCount.unwrap(value): java.lang.Long)
      )(_.pendingCount)
      .optionallyWith(
        runningCount.map(value => ECSTaskSetCount.unwrap(value): java.lang.Long)
      )(_.runningCount)
      .optionallyWith(
        status.map(value => ECSTaskSetStatus.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        trafficWeight.map(value =>
          TrafficWeight.unwrap(value): java.lang.Double
        )
      )(_.trafficWeight)
      .optionallyWith(targetGroup.map(value => value.buildAwsValue()))(
        _.targetGroup
      )
      .optionallyWith(taskSetLabel.map(value => value.unwrap))(_.taskSetLabel)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.ECSTaskSet.ReadOnly =
    zio.aws.codedeploy.model.ECSTaskSet.wrap(buildAwsValue())
}
object ECSTaskSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ECSTaskSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ECSTaskSet =
      zio.aws.codedeploy.model.ECSTaskSet(
        identifer.map(value => value),
        desiredCount.map(value => value),
        pendingCount.map(value => value),
        runningCount.map(value => value),
        status.map(value => value),
        trafficWeight.map(value => value),
        targetGroup.map(value => value.asEditable),
        taskSetLabel.map(value => value)
      )
    def identifer: Optional[ECSTaskSetIdentifier]
    def desiredCount: Optional[ECSTaskSetCount]
    def pendingCount: Optional[ECSTaskSetCount]
    def runningCount: Optional[ECSTaskSetCount]
    def status: Optional[ECSTaskSetStatus]
    def trafficWeight: Optional[TrafficWeight]
    def targetGroup: Optional[zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly]
    def taskSetLabel: Optional[zio.aws.codedeploy.model.TargetLabel]
    def getIdentifer: ZIO[Any, AwsError, ECSTaskSetIdentifier] =
      AwsError.unwrapOptionField("identifer", identifer)
    def getDesiredCount: ZIO[Any, AwsError, ECSTaskSetCount] =
      AwsError.unwrapOptionField("desiredCount", desiredCount)
    def getPendingCount: ZIO[Any, AwsError, ECSTaskSetCount] =
      AwsError.unwrapOptionField("pendingCount", pendingCount)
    def getRunningCount: ZIO[Any, AwsError, ECSTaskSetCount] =
      AwsError.unwrapOptionField("runningCount", runningCount)
    def getStatus: ZIO[Any, AwsError, ECSTaskSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTrafficWeight: ZIO[Any, AwsError, TrafficWeight] =
      AwsError.unwrapOptionField("trafficWeight", trafficWeight)
    def getTargetGroup: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly
    ] = AwsError.unwrapOptionField("targetGroup", targetGroup)
    def getTaskSetLabel
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.TargetLabel] =
      AwsError.unwrapOptionField("taskSetLabel", taskSetLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ECSTaskSet
  ) extends zio.aws.codedeploy.model.ECSTaskSet.ReadOnly {
    override val identifer: Optional[ECSTaskSetIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identifer())
        .map(value =>
          zio.aws.codedeploy.model.primitives.ECSTaskSetIdentifier(value)
        )
    override val desiredCount: Optional[ECSTaskSetCount] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredCount())
      .map(value => zio.aws.codedeploy.model.primitives.ECSTaskSetCount(value))
    override val pendingCount: Optional[ECSTaskSetCount] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingCount())
      .map(value => zio.aws.codedeploy.model.primitives.ECSTaskSetCount(value))
    override val runningCount: Optional[ECSTaskSetCount] = zio.aws.core.internal
      .optionalFromNullable(impl.runningCount())
      .map(value => zio.aws.codedeploy.model.primitives.ECSTaskSetCount(value))
    override val status: Optional[ECSTaskSetStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.codedeploy.model.primitives.ECSTaskSetStatus(value))
    override val trafficWeight: Optional[TrafficWeight] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficWeight())
      .map(value => zio.aws.codedeploy.model.primitives.TrafficWeight(value))
    override val targetGroup
        : Optional[zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetGroup())
        .map(value => zio.aws.codedeploy.model.TargetGroupInfo.wrap(value))
    override val taskSetLabel: Optional[zio.aws.codedeploy.model.TargetLabel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskSetLabel())
        .map(value => zio.aws.codedeploy.model.TargetLabel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ECSTaskSet
  ): zio.aws.codedeploy.model.ECSTaskSet.ReadOnly = new Wrapper(impl)
}
