package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait StopStatus {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.StopStatus
}
object StopStatus {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.StopStatus
  ): zio.aws.codedeploy.model.StopStatus = value match {
    case software.amazon.awssdk.services.codedeploy.model.StopStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.StopStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.codedeploy.model.StopStatus.SUCCEEDED =>
      val r = Succeeded
      r
  }
  case object unknownToSdkVersion extends zio.aws.codedeploy.model.StopStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.StopStatus =
      software.amazon.awssdk.services.codedeploy.model.StopStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.codedeploy.model.StopStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.StopStatus =
      software.amazon.awssdk.services.codedeploy.model.StopStatus.PENDING
  }
  case object Succeeded extends zio.aws.codedeploy.model.StopStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.StopStatus =
      software.amazon.awssdk.services.codedeploy.model.StopStatus.SUCCEEDED
  }
}
