package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait InstanceAction {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.InstanceAction
}
object InstanceAction {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.InstanceAction
  ): zio.aws.codedeploy.model.InstanceAction = value match {
    case software.amazon.awssdk.services.codedeploy.model.InstanceAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.InstanceAction.TERMINATE =>
      val r = TERMINATE
      r
    case software.amazon.awssdk.services.codedeploy.model.InstanceAction.KEEP_ALIVE =>
      val r = KEEP_ALIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.InstanceAction {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.InstanceAction =
      software.amazon.awssdk.services.codedeploy.model.InstanceAction.UNKNOWN_TO_SDK_VERSION
  }
  case object TERMINATE extends zio.aws.codedeploy.model.InstanceAction {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.InstanceAction =
      software.amazon.awssdk.services.codedeploy.model.InstanceAction.TERMINATE
  }
  case object KEEP_ALIVE extends zio.aws.codedeploy.model.InstanceAction {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.InstanceAction =
      software.amazon.awssdk.services.codedeploy.model.InstanceAction.KEEP_ALIVE
  }
}
