package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait RegistrationStatus {
  def unwrap
      : software.amazon.awssdk.services.codedeploy.model.RegistrationStatus
}
object RegistrationStatus {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.RegistrationStatus
  ): zio.aws.codedeploy.model.RegistrationStatus = value match {
    case software.amazon.awssdk.services.codedeploy.model.RegistrationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.RegistrationStatus.REGISTERED =>
      val r = Registered
      r
    case software.amazon.awssdk.services.codedeploy.model.RegistrationStatus.DEREGISTERED =>
      val r = Deregistered
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.RegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.RegistrationStatus =
      software.amazon.awssdk.services.codedeploy.model.RegistrationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Registered extends zio.aws.codedeploy.model.RegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.RegistrationStatus =
      software.amazon.awssdk.services.codedeploy.model.RegistrationStatus.REGISTERED
  }
  case object Deregistered extends zio.aws.codedeploy.model.RegistrationStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.RegistrationStatus =
      software.amazon.awssdk.services.codedeploy.model.RegistrationStatus.DEREGISTERED
  }
}
