package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetOnPremisesInstanceResponse(
    instanceInfo: Option[zio.aws.codedeploy.model.InstanceInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceResponse = {
    import GetOnPremisesInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceResponse
      .builder()
      .optionallyWith(instanceInfo.map(value => value.buildAwsValue()))(
        _.instanceInfo
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.GetOnPremisesInstanceResponse.ReadOnly =
    zio.aws.codedeploy.model.GetOnPremisesInstanceResponse.wrap(buildAwsValue())
}
object GetOnPremisesInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetOnPremisesInstanceResponse =
      zio.aws.codedeploy.model.GetOnPremisesInstanceResponse(
        instanceInfo.map(value => value.asEditable)
      )
    def instanceInfo: Option[zio.aws.codedeploy.model.InstanceInfo.ReadOnly]
    def getInstanceInfo
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.InstanceInfo.ReadOnly] =
      AwsError.unwrapOptionField("instanceInfo", instanceInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceResponse
  ) extends zio.aws.codedeploy.model.GetOnPremisesInstanceResponse.ReadOnly {
    override val instanceInfo
        : Option[zio.aws.codedeploy.model.InstanceInfo.ReadOnly] = scala
      .Option(impl.instanceInfo())
      .map(value => zio.aws.codedeploy.model.InstanceInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetOnPremisesInstanceResponse
  ): zio.aws.codedeploy.model.GetOnPremisesInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
