package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BlueGreenDeploymentConfiguration(
    terminateBlueInstancesOnDeploymentSuccess: Option[
      zio.aws.codedeploy.model.BlueInstanceTerminationOption
    ] = None,
    deploymentReadyOption: Option[
      zio.aws.codedeploy.model.DeploymentReadyOption
    ] = None,
    greenFleetProvisioningOption: Option[
      zio.aws.codedeploy.model.GreenFleetProvisioningOption
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BlueGreenDeploymentConfiguration = {
    import BlueGreenDeploymentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BlueGreenDeploymentConfiguration
      .builder()
      .optionallyWith(
        terminateBlueInstancesOnDeploymentSuccess.map(value =>
          value.buildAwsValue()
        )
      )(_.terminateBlueInstancesOnDeploymentSuccess)
      .optionallyWith(
        deploymentReadyOption.map(value => value.buildAwsValue())
      )(_.deploymentReadyOption)
      .optionallyWith(
        greenFleetProvisioningOption.map(value => value.buildAwsValue())
      )(_.greenFleetProvisioningOption)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.ReadOnly =
    zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration
      .wrap(buildAwsValue())
}
object BlueGreenDeploymentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BlueGreenDeploymentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration =
      zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration(
        terminateBlueInstancesOnDeploymentSuccess.map(value =>
          value.asEditable
        ),
        deploymentReadyOption.map(value => value.asEditable),
        greenFleetProvisioningOption.map(value => value.asEditable)
      )
    def terminateBlueInstancesOnDeploymentSuccess: Option[
      zio.aws.codedeploy.model.BlueInstanceTerminationOption.ReadOnly
    ]
    def deploymentReadyOption
        : Option[zio.aws.codedeploy.model.DeploymentReadyOption.ReadOnly]
    def greenFleetProvisioningOption
        : Option[zio.aws.codedeploy.model.GreenFleetProvisioningOption.ReadOnly]
    def getTerminateBlueInstancesOnDeploymentSuccess: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.BlueInstanceTerminationOption.ReadOnly
    ] = AwsError.unwrapOptionField(
      "terminateBlueInstancesOnDeploymentSuccess",
      terminateBlueInstancesOnDeploymentSuccess
    )
    def getDeploymentReadyOption: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.DeploymentReadyOption.ReadOnly
    ] =
      AwsError.unwrapOptionField("deploymentReadyOption", deploymentReadyOption)
    def getGreenFleetProvisioningOption: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.GreenFleetProvisioningOption.ReadOnly
    ] = AwsError.unwrapOptionField(
      "greenFleetProvisioningOption",
      greenFleetProvisioningOption
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BlueGreenDeploymentConfiguration
  ) extends zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.ReadOnly {
    override val terminateBlueInstancesOnDeploymentSuccess: Option[
      zio.aws.codedeploy.model.BlueInstanceTerminationOption.ReadOnly
    ] = scala
      .Option(impl.terminateBlueInstancesOnDeploymentSuccess())
      .map(value =>
        zio.aws.codedeploy.model.BlueInstanceTerminationOption.wrap(value)
      )
    override val deploymentReadyOption
        : Option[zio.aws.codedeploy.model.DeploymentReadyOption.ReadOnly] =
      scala
        .Option(impl.deploymentReadyOption())
        .map(value =>
          zio.aws.codedeploy.model.DeploymentReadyOption.wrap(value)
        )
    override val greenFleetProvisioningOption: Option[
      zio.aws.codedeploy.model.GreenFleetProvisioningOption.ReadOnly
    ] = scala
      .Option(impl.greenFleetProvisioningOption())
      .map(value =>
        zio.aws.codedeploy.model.GreenFleetProvisioningOption.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BlueGreenDeploymentConfiguration
  ): zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.ReadOnly =
    new Wrapper(impl)
}
