package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.DeploymentId
import scala.jdk.CollectionConverters.*
final case class ContinueDeploymentRequest(
    deploymentId: Option[DeploymentId] = None,
    deploymentWaitType: Option[zio.aws.codedeploy.model.DeploymentWaitType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest = {
    import ContinueDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(deploymentWaitType.map(value => value.unwrap))(
        _.deploymentWaitType
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.ContinueDeploymentRequest.ReadOnly =
    zio.aws.codedeploy.model.ContinueDeploymentRequest.wrap(buildAwsValue())
}
object ContinueDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ContinueDeploymentRequest =
      zio.aws.codedeploy.model.ContinueDeploymentRequest(
        deploymentId.map(value => value),
        deploymentWaitType.map(value => value)
      )
    def deploymentId: Option[DeploymentId]
    def deploymentWaitType: Option[zio.aws.codedeploy.model.DeploymentWaitType]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getDeploymentWaitType
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.DeploymentWaitType] =
      AwsError.unwrapOptionField("deploymentWaitType", deploymentWaitType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest
  ) extends zio.aws.codedeploy.model.ContinueDeploymentRequest.ReadOnly {
    override val deploymentId: Option[DeploymentId] = scala
      .Option(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val deploymentWaitType
        : Option[zio.aws.codedeploy.model.DeploymentWaitType] = scala
      .Option(impl.deploymentWaitType())
      .map(value => zio.aws.codedeploy.model.DeploymentWaitType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest
  ): zio.aws.codedeploy.model.ContinueDeploymentRequest.ReadOnly = new Wrapper(
    impl
  )
}
