package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait EC2TagFilterType {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType
}
object EC2TagFilterType {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType
  ): zio.aws.codedeploy.model.EC2TagFilterType = value match {
    case software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType.KEY_ONLY =>
      val r = KEY_ONLY
      r
    case software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType.VALUE_ONLY =>
      val r = VALUE_ONLY
      r
    case software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType.KEY_AND_VALUE =>
      val r = KEY_AND_VALUE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.EC2TagFilterType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType =
      software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType.UNKNOWN_TO_SDK_VERSION
  }
  case object KEY_ONLY extends zio.aws.codedeploy.model.EC2TagFilterType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType =
      software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType.KEY_ONLY
  }
  case object VALUE_ONLY extends zio.aws.codedeploy.model.EC2TagFilterType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType =
      software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType.VALUE_ONLY
  }
  case object KEY_AND_VALUE extends zio.aws.codedeploy.model.EC2TagFilterType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType =
      software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType.KEY_AND_VALUE
  }
}
