package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{ETag, VersionId, S3Key, S3Bucket}
import scala.jdk.CollectionConverters.*
final case class S3Location(
    bucket: Option[S3Bucket] = None,
    key: Option[S3Key] = None,
    bundleType: Option[zio.aws.codedeploy.model.BundleType] = None,
    version: Option[VersionId] = None,
    eTag: Option[ETag] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.S3Location
      .builder()
      .optionallyWith(
        bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(key.map(value => S3Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(bundleType.map(value => value.unwrap))(_.bundleType)
      .optionallyWith(
        version.map(value => VersionId.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(eTag.map(value => ETag.unwrap(value): java.lang.String))(
        _.eTag
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.S3Location.ReadOnly =
    zio.aws.codedeploy.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.S3Location =
      zio.aws.codedeploy.model.S3Location(
        bucket.map(value => value),
        key.map(value => value),
        bundleType.map(value => value),
        version.map(value => value),
        eTag.map(value => value)
      )
    def bucket: Option[S3Bucket]
    def key: Option[S3Key]
    def bundleType: Option[zio.aws.codedeploy.model.BundleType]
    def version: Option[VersionId]
    def eTag: Option[ETag]
    def getBucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("key", key)
    def getBundleType: ZIO[Any, AwsError, zio.aws.codedeploy.model.BundleType] =
      AwsError.unwrapOptionField("bundleType", bundleType)
    def getVersion: ZIO[Any, AwsError, VersionId] =
      AwsError.unwrapOptionField("version", version)
    def getETag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.S3Location
  ) extends zio.aws.codedeploy.model.S3Location.ReadOnly {
    override val bucket: Option[S3Bucket] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.codedeploy.model.primitives.S3Bucket(value))
    override val key: Option[S3Key] = scala
      .Option(impl.key())
      .map(value => zio.aws.codedeploy.model.primitives.S3Key(value))
    override val bundleType: Option[zio.aws.codedeploy.model.BundleType] = scala
      .Option(impl.bundleType())
      .map(value => zio.aws.codedeploy.model.BundleType.wrap(value))
    override val version: Option[VersionId] = scala
      .Option(impl.version())
      .map(value => zio.aws.codedeploy.model.primitives.VersionId(value))
    override val eTag: Option[ETag] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.codedeploy.model.primitives.ETag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.S3Location
  ): zio.aws.codedeploy.model.S3Location.ReadOnly = new Wrapper(impl)
}
