package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  Timestamp,
  DeploymentConfigName,
  DeploymentConfigId
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DeploymentConfigInfo(
    deploymentConfigId: Option[DeploymentConfigId] = None,
    deploymentConfigName: Option[DeploymentConfigName] = None,
    minimumHealthyHosts: Option[zio.aws.codedeploy.model.MinimumHealthyHosts] =
      None,
    createTime: Option[Timestamp] = None,
    computePlatform: Option[zio.aws.codedeploy.model.ComputePlatform] = None,
    trafficRoutingConfig: Option[
      zio.aws.codedeploy.model.TrafficRoutingConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeploymentConfigInfo = {
    import DeploymentConfigInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeploymentConfigInfo
      .builder()
      .optionallyWith(
        deploymentConfigId.map(value =>
          DeploymentConfigId.unwrap(value): java.lang.String
        )
      )(_.deploymentConfigId)
      .optionallyWith(
        deploymentConfigName.map(value =>
          DeploymentConfigName.unwrap(value): java.lang.String
        )
      )(_.deploymentConfigName)
      .optionallyWith(minimumHealthyHosts.map(value => value.buildAwsValue()))(
        _.minimumHealthyHosts
      )
      .optionallyWith(
        createTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTime)
      .optionallyWith(computePlatform.map(value => value.unwrap))(
        _.computePlatform
      )
      .optionallyWith(trafficRoutingConfig.map(value => value.buildAwsValue()))(
        _.trafficRoutingConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.DeploymentConfigInfo.ReadOnly =
    zio.aws.codedeploy.model.DeploymentConfigInfo.wrap(buildAwsValue())
}
object DeploymentConfigInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeploymentConfigInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.DeploymentConfigInfo =
      zio.aws.codedeploy.model.DeploymentConfigInfo(
        deploymentConfigId.map(value => value),
        deploymentConfigName.map(value => value),
        minimumHealthyHosts.map(value => value.asEditable),
        createTime.map(value => value),
        computePlatform.map(value => value),
        trafficRoutingConfig.map(value => value.asEditable)
      )
    def deploymentConfigId: Option[DeploymentConfigId]
    def deploymentConfigName: Option[DeploymentConfigName]
    def minimumHealthyHosts
        : Option[zio.aws.codedeploy.model.MinimumHealthyHosts.ReadOnly]
    def createTime: Option[Timestamp]
    def computePlatform: Option[zio.aws.codedeploy.model.ComputePlatform]
    def trafficRoutingConfig
        : Option[zio.aws.codedeploy.model.TrafficRoutingConfig.ReadOnly]
    def getDeploymentConfigId: ZIO[Any, AwsError, DeploymentConfigId] =
      AwsError.unwrapOptionField("deploymentConfigId", deploymentConfigId)
    def getDeploymentConfigName: ZIO[Any, AwsError, DeploymentConfigName] =
      AwsError.unwrapOptionField("deploymentConfigName", deploymentConfigName)
    def getMinimumHealthyHosts: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.MinimumHealthyHosts.ReadOnly
    ] = AwsError.unwrapOptionField("minimumHealthyHosts", minimumHealthyHosts)
    def getCreateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getComputePlatform
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.ComputePlatform] =
      AwsError.unwrapOptionField("computePlatform", computePlatform)
    def getTrafficRoutingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.TrafficRoutingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("trafficRoutingConfig", trafficRoutingConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentConfigInfo
  ) extends zio.aws.codedeploy.model.DeploymentConfigInfo.ReadOnly {
    override val deploymentConfigId: Option[DeploymentConfigId] = scala
      .Option(impl.deploymentConfigId())
      .map(value =>
        zio.aws.codedeploy.model.primitives.DeploymentConfigId(value)
      )
    override val deploymentConfigName: Option[DeploymentConfigName] = scala
      .Option(impl.deploymentConfigName())
      .map(value =>
        zio.aws.codedeploy.model.primitives.DeploymentConfigName(value)
      )
    override val minimumHealthyHosts
        : Option[zio.aws.codedeploy.model.MinimumHealthyHosts.ReadOnly] = scala
      .Option(impl.minimumHealthyHosts())
      .map(value => zio.aws.codedeploy.model.MinimumHealthyHosts.wrap(value))
    override val createTime: Option[Timestamp] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val computePlatform
        : Option[zio.aws.codedeploy.model.ComputePlatform] = scala
      .Option(impl.computePlatform())
      .map(value => zio.aws.codedeploy.model.ComputePlatform.wrap(value))
    override val trafficRoutingConfig
        : Option[zio.aws.codedeploy.model.TrafficRoutingConfig.ReadOnly] = scala
      .Option(impl.trafficRoutingConfig())
      .map(value => zio.aws.codedeploy.model.TrafficRoutingConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentConfigInfo
  ): zio.aws.codedeploy.model.DeploymentConfigInfo.ReadOnly = new Wrapper(impl)
}
