package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.GitHubAccountTokenName
import scala.jdk.CollectionConverters.*
final case class DeleteGitHubAccountTokenRequest(
    tokenName: Option[GitHubAccountTokenName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenRequest = {
    import DeleteGitHubAccountTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenRequest
      .builder()
      .optionallyWith(
        tokenName.map(value =>
          GitHubAccountTokenName.unwrap(value): java.lang.String
        )
      )(_.tokenName)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.DeleteGitHubAccountTokenRequest.ReadOnly =
    zio.aws.codedeploy.model.DeleteGitHubAccountTokenRequest
      .wrap(buildAwsValue())
}
object DeleteGitHubAccountTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.DeleteGitHubAccountTokenRequest =
      zio.aws.codedeploy.model
        .DeleteGitHubAccountTokenRequest(tokenName.map(value => value))
    def tokenName: Option[GitHubAccountTokenName]
    def getTokenName: ZIO[Any, AwsError, GitHubAccountTokenName] =
      AwsError.unwrapOptionField("tokenName", tokenName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenRequest
  ) extends zio.aws.codedeploy.model.DeleteGitHubAccountTokenRequest.ReadOnly {
    override val tokenName: Option[GitHubAccountTokenName] = scala
      .Option(impl.tokenName())
      .map(value =>
        zio.aws.codedeploy.model.primitives.GitHubAccountTokenName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenRequest
  ): zio.aws.codedeploy.model.DeleteGitHubAccountTokenRequest.ReadOnly =
    new Wrapper(impl)
}
