package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  TrafficWeight,
  Version,
  LambdaFunctionAlias,
  LambdaFunctionName
}
import scala.jdk.CollectionConverters.*
final case class LambdaFunctionInfo(
    functionName: Option[LambdaFunctionName] = None,
    functionAlias: Option[LambdaFunctionAlias] = None,
    currentVersion: Option[Version] = None,
    targetVersion: Option[Version] = None,
    targetVersionWeight: Option[TrafficWeight] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.LambdaFunctionInfo = {
    import LambdaFunctionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.LambdaFunctionInfo
      .builder()
      .optionallyWith(
        functionName.map(value =>
          LambdaFunctionName.unwrap(value): java.lang.String
        )
      )(_.functionName)
      .optionallyWith(
        functionAlias.map(value =>
          LambdaFunctionAlias.unwrap(value): java.lang.String
        )
      )(_.functionAlias)
      .optionallyWith(
        currentVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.currentVersion)
      .optionallyWith(
        targetVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.targetVersion)
      .optionallyWith(
        targetVersionWeight.map(value =>
          TrafficWeight.unwrap(value): java.lang.Double
        )
      )(_.targetVersionWeight)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.LambdaFunctionInfo.ReadOnly =
    zio.aws.codedeploy.model.LambdaFunctionInfo.wrap(buildAwsValue())
}
object LambdaFunctionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.LambdaFunctionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.LambdaFunctionInfo =
      zio.aws.codedeploy.model.LambdaFunctionInfo(
        functionName.map(value => value),
        functionAlias.map(value => value),
        currentVersion.map(value => value),
        targetVersion.map(value => value),
        targetVersionWeight.map(value => value)
      )
    def functionName: Option[LambdaFunctionName]
    def functionAlias: Option[LambdaFunctionAlias]
    def currentVersion: Option[Version]
    def targetVersion: Option[Version]
    def targetVersionWeight: Option[TrafficWeight]
    def getFunctionName: ZIO[Any, AwsError, LambdaFunctionName] =
      AwsError.unwrapOptionField("functionName", functionName)
    def getFunctionAlias: ZIO[Any, AwsError, LambdaFunctionAlias] =
      AwsError.unwrapOptionField("functionAlias", functionAlias)
    def getCurrentVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getTargetVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("targetVersion", targetVersion)
    def getTargetVersionWeight: ZIO[Any, AwsError, TrafficWeight] =
      AwsError.unwrapOptionField("targetVersionWeight", targetVersionWeight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.LambdaFunctionInfo
  ) extends zio.aws.codedeploy.model.LambdaFunctionInfo.ReadOnly {
    override val functionName: Option[LambdaFunctionName] = scala
      .Option(impl.functionName())
      .map(value =>
        zio.aws.codedeploy.model.primitives.LambdaFunctionName(value)
      )
    override val functionAlias: Option[LambdaFunctionAlias] = scala
      .Option(impl.functionAlias())
      .map(value =>
        zio.aws.codedeploy.model.primitives.LambdaFunctionAlias(value)
      )
    override val currentVersion: Option[Version] = scala
      .Option(impl.currentVersion())
      .map(value => zio.aws.codedeploy.model.primitives.Version(value))
    override val targetVersion: Option[Version] = scala
      .Option(impl.targetVersion())
      .map(value => zio.aws.codedeploy.model.primitives.Version(value))
    override val targetVersionWeight: Option[TrafficWeight] = scala
      .Option(impl.targetVersionWeight())
      .map(value => zio.aws.codedeploy.model.primitives.TrafficWeight(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.LambdaFunctionInfo
  ): zio.aws.codedeploy.model.LambdaFunctionInfo.ReadOnly = new Wrapper(impl)
}
