package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.ErrorMessage
import scala.jdk.CollectionConverters.*
final case class ErrorInformation(
    code: Option[zio.aws.codedeploy.model.ErrorCode] = None,
    message: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ErrorInformation = {
    import ErrorInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ErrorInformation
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.ErrorInformation.ReadOnly =
    zio.aws.codedeploy.model.ErrorInformation.wrap(buildAwsValue())
}
object ErrorInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ErrorInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ErrorInformation =
      zio.aws.codedeploy.model
        .ErrorInformation(code.map(value => value), message.map(value => value))
    def code: Option[zio.aws.codedeploy.model.ErrorCode]
    def message: Option[ErrorMessage]
    def getCode: ZIO[Any, AwsError, zio.aws.codedeploy.model.ErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ErrorInformation
  ) extends zio.aws.codedeploy.model.ErrorInformation.ReadOnly {
    override val code: Option[zio.aws.codedeploy.model.ErrorCode] = scala
      .Option(impl.code())
      .map(value => zio.aws.codedeploy.model.ErrorCode.wrap(value))
    override val message: Option[ErrorMessage] = scala
      .Option(impl.message())
      .map(value => zio.aws.codedeploy.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ErrorInformation
  ): zio.aws.codedeploy.model.ErrorInformation.ReadOnly = new Wrapper(impl)
}
