package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDeploymentTargetResponse(
    deploymentTarget: Option[zio.aws.codedeploy.model.DeploymentTarget] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetResponse = {
    import GetDeploymentTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetResponse
      .builder()
      .optionallyWith(deploymentTarget.map(value => value.buildAwsValue()))(
        _.deploymentTarget
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.GetDeploymentTargetResponse.ReadOnly =
    zio.aws.codedeploy.model.GetDeploymentTargetResponse.wrap(buildAwsValue())
}
object GetDeploymentTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetDeploymentTargetResponse =
      zio.aws.codedeploy.model.GetDeploymentTargetResponse(
        deploymentTarget.map(value => value.asEditable)
      )
    def deploymentTarget
        : Option[zio.aws.codedeploy.model.DeploymentTarget.ReadOnly]
    def getDeploymentTarget: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.DeploymentTarget.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentTarget", deploymentTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetResponse
  ) extends zio.aws.codedeploy.model.GetDeploymentTargetResponse.ReadOnly {
    override val deploymentTarget
        : Option[zio.aws.codedeploy.model.DeploymentTarget.ReadOnly] = scala
      .Option(impl.deploymentTarget())
      .map(value => zio.aws.codedeploy.model.DeploymentTarget.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetResponse
  ): zio.aws.codedeploy.model.GetDeploymentTargetResponse.ReadOnly =
    new Wrapper(impl)
}
