package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.TargetGroupName
import scala.jdk.CollectionConverters.*
final case class TargetGroupInfo(name: Option[TargetGroupName] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.TargetGroupInfo = {
    import TargetGroupInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.TargetGroupInfo
      .builder()
      .optionallyWith(
        name.map(value => TargetGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly =
    zio.aws.codedeploy.model.TargetGroupInfo.wrap(buildAwsValue())
}
object TargetGroupInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.TargetGroupInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.TargetGroupInfo =
      zio.aws.codedeploy.model.TargetGroupInfo(name.map(value => value))
    def name: Option[TargetGroupName]
    def getName: ZIO[Any, AwsError, TargetGroupName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.TargetGroupInfo
  ) extends zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly {
    override val name: Option[TargetGroupName] = scala
      .Option(impl.name())
      .map(value => zio.aws.codedeploy.model.primitives.TargetGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.TargetGroupInfo
  ): zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly = new Wrapper(impl)
}
