package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.ErrorMessage
import scala.jdk.CollectionConverters.*
final case class BatchGetDeploymentGroupsResponse(
    deploymentGroupsInfo: Option[
      Iterable[zio.aws.codedeploy.model.DeploymentGroupInfo]
    ] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsResponse = {
    import BatchGetDeploymentGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsResponse
      .builder()
      .optionallyWith(
        deploymentGroupsInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deploymentGroupsInfo)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.BatchGetDeploymentGroupsResponse.ReadOnly =
    zio.aws.codedeploy.model.BatchGetDeploymentGroupsResponse
      .wrap(buildAwsValue())
}
object BatchGetDeploymentGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.BatchGetDeploymentGroupsResponse =
      zio.aws.codedeploy.model.BatchGetDeploymentGroupsResponse(
        deploymentGroupsInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errorMessage.map(value => value)
      )
    def deploymentGroupsInfo
        : Option[List[zio.aws.codedeploy.model.DeploymentGroupInfo.ReadOnly]]
    def errorMessage: Option[ErrorMessage]
    def getDeploymentGroupsInfo: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.DeploymentGroupInfo.ReadOnly
    ]] =
      AwsError.unwrapOptionField("deploymentGroupsInfo", deploymentGroupsInfo)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsResponse
  ) extends zio.aws.codedeploy.model.BatchGetDeploymentGroupsResponse.ReadOnly {
    override val deploymentGroupsInfo
        : Option[List[zio.aws.codedeploy.model.DeploymentGroupInfo.ReadOnly]] =
      scala
        .Option(impl.deploymentGroupsInfo())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.DeploymentGroupInfo.wrap(item)
          }.toList
        )
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.codedeploy.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentGroupsResponse
  ): zio.aws.codedeploy.model.BatchGetDeploymentGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
