package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  LogTail,
  LifecycleMessage,
  ScriptName
}
import scala.jdk.CollectionConverters.*
final case class Diagnostics(
    errorCode: Option[zio.aws.codedeploy.model.LifecycleErrorCode] = None,
    scriptName: Option[ScriptName] = None,
    message: Option[LifecycleMessage] = None,
    logTail: Option[LogTail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.Diagnostics = {
    import Diagnostics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.Diagnostics
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        scriptName.map(value => ScriptName.unwrap(value): java.lang.String)
      )(_.scriptName)
      .optionallyWith(
        message.map(value => LifecycleMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        logTail.map(value => LogTail.unwrap(value): java.lang.String)
      )(_.logTail)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.Diagnostics.ReadOnly =
    zio.aws.codedeploy.model.Diagnostics.wrap(buildAwsValue())
}
object Diagnostics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.Diagnostics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.Diagnostics =
      zio.aws.codedeploy.model.Diagnostics(
        errorCode.map(value => value),
        scriptName.map(value => value),
        message.map(value => value),
        logTail.map(value => value)
      )
    def errorCode: Option[zio.aws.codedeploy.model.LifecycleErrorCode]
    def scriptName: Option[ScriptName]
    def message: Option[LifecycleMessage]
    def logTail: Option[LogTail]
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.LifecycleErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getScriptName: ZIO[Any, AwsError, ScriptName] =
      AwsError.unwrapOptionField("scriptName", scriptName)
    def getMessage: ZIO[Any, AwsError, LifecycleMessage] =
      AwsError.unwrapOptionField("message", message)
    def getLogTail: ZIO[Any, AwsError, LogTail] =
      AwsError.unwrapOptionField("logTail", logTail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.Diagnostics
  ) extends zio.aws.codedeploy.model.Diagnostics.ReadOnly {
    override val errorCode
        : Option[zio.aws.codedeploy.model.LifecycleErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.codedeploy.model.LifecycleErrorCode.wrap(value))
    override val scriptName: Option[ScriptName] = scala
      .Option(impl.scriptName())
      .map(value => zio.aws.codedeploy.model.primitives.ScriptName(value))
    override val message: Option[LifecycleMessage] = scala
      .Option(impl.message())
      .map(value => zio.aws.codedeploy.model.primitives.LifecycleMessage(value))
    override val logTail: Option[LogTail] = scala
      .Option(impl.logTail())
      .map(value => zio.aws.codedeploy.model.primitives.LogTail(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.Diagnostics
  ): zio.aws.codedeploy.model.Diagnostics.ReadOnly = new Wrapper(impl)
}
