package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters.*
sealed trait TargetStatus {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.TargetStatus
}
object TargetStatus {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.TargetStatus
  ): zio.aws.codedeploy.model.TargetStatus = value match {
    case software.amazon.awssdk.services.codedeploy.model.TargetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.TargetStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.codedeploy.model.TargetStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.codedeploy.model.TargetStatus.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.codedeploy.model.TargetStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.codedeploy.model.TargetStatus.SKIPPED =>
      val r = Skipped
      r
    case software.amazon.awssdk.services.codedeploy.model.TargetStatus.UNKNOWN =>
      val r = Unknown
      r
    case software.amazon.awssdk.services.codedeploy.model.TargetStatus.READY =>
      val r = Ready
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.TargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TargetStatus =
      software.amazon.awssdk.services.codedeploy.model.TargetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.codedeploy.model.TargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TargetStatus =
      software.amazon.awssdk.services.codedeploy.model.TargetStatus.PENDING
  }
  case object InProgress extends zio.aws.codedeploy.model.TargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TargetStatus =
      software.amazon.awssdk.services.codedeploy.model.TargetStatus.IN_PROGRESS
  }
  case object Succeeded extends zio.aws.codedeploy.model.TargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TargetStatus =
      software.amazon.awssdk.services.codedeploy.model.TargetStatus.SUCCEEDED
  }
  case object Failed extends zio.aws.codedeploy.model.TargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TargetStatus =
      software.amazon.awssdk.services.codedeploy.model.TargetStatus.FAILED
  }
  case object Skipped extends zio.aws.codedeploy.model.TargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TargetStatus =
      software.amazon.awssdk.services.codedeploy.model.TargetStatus.SKIPPED
  }
  case object Unknown extends zio.aws.codedeploy.model.TargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TargetStatus =
      software.amazon.awssdk.services.codedeploy.model.TargetStatus.UNKNOWN
  }
  case object Ready extends zio.aws.codedeploy.model.TargetStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TargetStatus =
      software.amazon.awssdk.services.codedeploy.model.TargetStatus.READY
  }
}
