package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TargetGroupPairInfo(
    targetGroups: Option[Iterable[zio.aws.codedeploy.model.TargetGroupInfo]] =
      None,
    prodTrafficRoute: Option[zio.aws.codedeploy.model.TrafficRoute] = None,
    testTrafficRoute: Option[zio.aws.codedeploy.model.TrafficRoute] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.TargetGroupPairInfo = {
    import TargetGroupPairInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.TargetGroupPairInfo
      .builder()
      .optionallyWith(
        targetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetGroups)
      .optionallyWith(prodTrafficRoute.map(value => value.buildAwsValue()))(
        _.prodTrafficRoute
      )
      .optionallyWith(testTrafficRoute.map(value => value.buildAwsValue()))(
        _.testTrafficRoute
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.TargetGroupPairInfo.ReadOnly =
    zio.aws.codedeploy.model.TargetGroupPairInfo.wrap(buildAwsValue())
}
object TargetGroupPairInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.TargetGroupPairInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.TargetGroupPairInfo =
      zio.aws.codedeploy.model.TargetGroupPairInfo(
        targetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        prodTrafficRoute.map(value => value.asEditable),
        testTrafficRoute.map(value => value.asEditable)
      )
    def targetGroups
        : Option[List[zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly]]
    def prodTrafficRoute: Option[zio.aws.codedeploy.model.TrafficRoute.ReadOnly]
    def testTrafficRoute: Option[zio.aws.codedeploy.model.TrafficRoute.ReadOnly]
    def getTargetGroups: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("targetGroups", targetGroups)
    def getProdTrafficRoute
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.TrafficRoute.ReadOnly] =
      AwsError.unwrapOptionField("prodTrafficRoute", prodTrafficRoute)
    def getTestTrafficRoute
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.TrafficRoute.ReadOnly] =
      AwsError.unwrapOptionField("testTrafficRoute", testTrafficRoute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.TargetGroupPairInfo
  ) extends zio.aws.codedeploy.model.TargetGroupPairInfo.ReadOnly {
    override val targetGroups
        : Option[List[zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly]] =
      scala
        .Option(impl.targetGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.TargetGroupInfo.wrap(item)
          }.toList
        )
    override val prodTrafficRoute
        : Option[zio.aws.codedeploy.model.TrafficRoute.ReadOnly] = scala
      .Option(impl.prodTrafficRoute())
      .map(value => zio.aws.codedeploy.model.TrafficRoute.wrap(value))
    override val testTrafficRoute
        : Option[zio.aws.codedeploy.model.TrafficRoute.ReadOnly] = scala
      .Option(impl.testTrafficRoute())
      .map(value => zio.aws.codedeploy.model.TrafficRoute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.TargetGroupPairInfo
  ): zio.aws.codedeploy.model.TargetGroupPairInfo.ReadOnly = new Wrapper(impl)
}
