package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListGitHubAccountTokenNamesRequest(
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest = {
    import ListGitHubAccountTokenNamesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListGitHubAccountTokenNamesRequest.ReadOnly =
    zio.aws.codedeploy.model.ListGitHubAccountTokenNamesRequest
      .wrap(buildAwsValue())
}
object ListGitHubAccountTokenNamesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codedeploy.model.ListGitHubAccountTokenNamesRequest =
      zio.aws.codedeploy.model
        .ListGitHubAccountTokenNamesRequest(nextToken.map(value => value))
    def nextToken: Option[NextToken]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest
  ) extends zio.aws.codedeploy.model.ListGitHubAccountTokenNamesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesRequest
  ): zio.aws.codedeploy.model.ListGitHubAccountTokenNamesRequest.ReadOnly =
    new Wrapper(impl)
}
