package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  NextToken,
  DeploymentGroupName,
  ApplicationName
}
import scala.jdk.CollectionConverters.*
final case class ListDeploymentGroupsResponse(
    applicationName: Option[ApplicationName] = None,
    deploymentGroups: Option[Iterable[DeploymentGroupName]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse = {
    import ListDeploymentGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        deploymentGroups.map(value =>
          value.map { item =>
            DeploymentGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deploymentGroups)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListDeploymentGroupsResponse.ReadOnly =
    zio.aws.codedeploy.model.ListDeploymentGroupsResponse.wrap(buildAwsValue())
}
object ListDeploymentGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListDeploymentGroupsResponse =
      zio.aws.codedeploy.model.ListDeploymentGroupsResponse(
        applicationName.map(value => value),
        deploymentGroups.map(value => value),
        nextToken.map(value => value)
      )
    def applicationName: Option[ApplicationName]
    def deploymentGroups: Option[List[DeploymentGroupName]]
    def nextToken: Option[NextToken]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getDeploymentGroups: ZIO[Any, AwsError, List[DeploymentGroupName]] =
      AwsError.unwrapOptionField("deploymentGroups", deploymentGroups)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse
  ) extends zio.aws.codedeploy.model.ListDeploymentGroupsResponse.ReadOnly {
    override val applicationName: Option[ApplicationName] = scala
      .Option(impl.applicationName())
      .map(value => zio.aws.codedeploy.model.primitives.ApplicationName(value))
    override val deploymentGroups: Option[List[DeploymentGroupName]] = scala
      .Option(impl.deploymentGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.primitives.DeploymentGroupName(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsResponse
  ): zio.aws.codedeploy.model.ListDeploymentGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
