package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.GitHubAccountTokenName
import scala.jdk.CollectionConverters.*
final case class DeleteGitHubAccountTokenResponse(
    tokenName: Option[GitHubAccountTokenName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenResponse = {
    import DeleteGitHubAccountTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenResponse
      .builder()
      .optionallyWith(
        tokenName.map(value =>
          GitHubAccountTokenName.unwrap(value): java.lang.String
        )
      )(_.tokenName)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.DeleteGitHubAccountTokenResponse.ReadOnly =
    zio.aws.codedeploy.model.DeleteGitHubAccountTokenResponse
      .wrap(buildAwsValue())
}
object DeleteGitHubAccountTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.DeleteGitHubAccountTokenResponse =
      zio.aws.codedeploy.model
        .DeleteGitHubAccountTokenResponse(tokenName.map(value => value))
    def tokenName: Option[GitHubAccountTokenName]
    def getTokenName: ZIO[Any, AwsError, GitHubAccountTokenName] =
      AwsError.unwrapOptionField("tokenName", tokenName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenResponse
  ) extends zio.aws.codedeploy.model.DeleteGitHubAccountTokenResponse.ReadOnly {
    override val tokenName: Option[GitHubAccountTokenName] = scala
      .Option(impl.tokenName())
      .map(value =>
        zio.aws.codedeploy.model.primitives.GitHubAccountTokenName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeleteGitHubAccountTokenResponse
  ): zio.aws.codedeploy.model.DeleteGitHubAccountTokenResponse.ReadOnly =
    new Wrapper(impl)
}
