package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListDeploymentConfigsRequest(
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest = {
    import ListDeploymentConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListDeploymentConfigsRequest.ReadOnly =
    zio.aws.codedeploy.model.ListDeploymentConfigsRequest.wrap(buildAwsValue())
}
object ListDeploymentConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListDeploymentConfigsRequest =
      zio.aws.codedeploy.model
        .ListDeploymentConfigsRequest(nextToken.map(value => value))
    def nextToken: Option[NextToken]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest
  ) extends zio.aws.codedeploy.model.ListDeploymentConfigsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest
  ): zio.aws.codedeploy.model.ListDeploymentConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
