package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{RawStringSha256, RawStringContent}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AppSpecContent(
    content: Optional[RawStringContent] = Optional.Absent,
    sha256: Optional[RawStringSha256] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.AppSpecContent = {
    import AppSpecContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.AppSpecContent
      .builder()
      .optionallyWith(
        content.map(value => RawStringContent.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        sha256.map(value => RawStringSha256.unwrap(value): java.lang.String)
      )(_.sha256)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.AppSpecContent.ReadOnly =
    zio.aws.codedeploy.model.AppSpecContent.wrap(buildAwsValue())
}
object AppSpecContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.AppSpecContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.AppSpecContent =
      zio.aws.codedeploy.model
        .AppSpecContent(content.map(value => value), sha256.map(value => value))
    def content: Optional[RawStringContent]
    def sha256: Optional[RawStringSha256]
    def getContent: ZIO[Any, AwsError, RawStringContent] =
      AwsError.unwrapOptionField("content", content)
    def getSha256: ZIO[Any, AwsError, RawStringSha256] =
      AwsError.unwrapOptionField("sha256", sha256)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.AppSpecContent
  ) extends zio.aws.codedeploy.model.AppSpecContent.ReadOnly {
    override val content: Optional[RawStringContent] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.codedeploy.model.primitives.RawStringContent(value))
    override val sha256: Optional[RawStringSha256] = zio.aws.core.internal
      .optionalFromNullable(impl.sha256())
      .map(value => zio.aws.codedeploy.model.primitives.RawStringSha256(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.AppSpecContent
  ): zio.aws.codedeploy.model.AppSpecContent.ReadOnly = new Wrapper(impl)
}
