package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{TargetId, DeploymentId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetDeploymentTargetsRequest(
    deploymentId: Optional[DeploymentId] = Optional.Absent,
    targetIds: Optional[Iterable[TargetId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsRequest = {
    import BatchGetDeploymentTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsRequest
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(
        targetIds.map(value =>
          value.map { item =>
            TargetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetIds)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.BatchGetDeploymentTargetsRequest.ReadOnly =
    zio.aws.codedeploy.model.BatchGetDeploymentTargetsRequest
      .wrap(buildAwsValue())
}
object BatchGetDeploymentTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.BatchGetDeploymentTargetsRequest =
      zio.aws.codedeploy.model.BatchGetDeploymentTargetsRequest(
        deploymentId.map(value => value),
        targetIds.map(value => value)
      )
    def deploymentId: Optional[DeploymentId]
    def targetIds: Optional[List[TargetId]]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getTargetIds: ZIO[Any, AwsError, List[TargetId]] =
      AwsError.unwrapOptionField("targetIds", targetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsRequest
  ) extends zio.aws.codedeploy.model.BatchGetDeploymentTargetsRequest.ReadOnly {
    override val deploymentId: Optional[DeploymentId] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val targetIds: Optional[List[TargetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.targetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.primitives.TargetId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetDeploymentTargetsRequest
  ): zio.aws.codedeploy.model.BatchGetDeploymentTargetsRequest.ReadOnly =
    new Wrapper(impl)
}
