package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.DeploymentConfigName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDeploymentConfigRequest(
    deploymentConfigName: DeploymentConfigName,
    minimumHealthyHosts: Optional[
      zio.aws.codedeploy.model.MinimumHealthyHosts
    ] = Optional.Absent,
    trafficRoutingConfig: Optional[
      zio.aws.codedeploy.model.TrafficRoutingConfig
    ] = Optional.Absent,
    computePlatform: Optional[zio.aws.codedeploy.model.ComputePlatform] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest = {
    import CreateDeploymentConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest
      .builder()
      .deploymentConfigName(
        DeploymentConfigName.unwrap(deploymentConfigName): java.lang.String
      )
      .optionallyWith(minimumHealthyHosts.map(value => value.buildAwsValue()))(
        _.minimumHealthyHosts
      )
      .optionallyWith(trafficRoutingConfig.map(value => value.buildAwsValue()))(
        _.trafficRoutingConfig
      )
      .optionallyWith(computePlatform.map(value => value.unwrap))(
        _.computePlatform
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.CreateDeploymentConfigRequest.ReadOnly =
    zio.aws.codedeploy.model.CreateDeploymentConfigRequest.wrap(buildAwsValue())
}
object CreateDeploymentConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.CreateDeploymentConfigRequest =
      zio.aws.codedeploy.model.CreateDeploymentConfigRequest(
        deploymentConfigName,
        minimumHealthyHosts.map(value => value.asEditable),
        trafficRoutingConfig.map(value => value.asEditable),
        computePlatform.map(value => value)
      )
    def deploymentConfigName: DeploymentConfigName
    def minimumHealthyHosts
        : Optional[zio.aws.codedeploy.model.MinimumHealthyHosts.ReadOnly]
    def trafficRoutingConfig
        : Optional[zio.aws.codedeploy.model.TrafficRoutingConfig.ReadOnly]
    def computePlatform: Optional[zio.aws.codedeploy.model.ComputePlatform]
    def getDeploymentConfigName: ZIO[Any, Nothing, DeploymentConfigName] =
      ZIO.succeed(deploymentConfigName)
    def getMinimumHealthyHosts: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.MinimumHealthyHosts.ReadOnly
    ] = AwsError.unwrapOptionField("minimumHealthyHosts", minimumHealthyHosts)
    def getTrafficRoutingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.TrafficRoutingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("trafficRoutingConfig", trafficRoutingConfig)
    def getComputePlatform
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.ComputePlatform] =
      AwsError.unwrapOptionField("computePlatform", computePlatform)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest
  ) extends zio.aws.codedeploy.model.CreateDeploymentConfigRequest.ReadOnly {
    override val deploymentConfigName: DeploymentConfigName =
      zio.aws.codedeploy.model.primitives
        .DeploymentConfigName(impl.deploymentConfigName())
    override val minimumHealthyHosts
        : Optional[zio.aws.codedeploy.model.MinimumHealthyHosts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minimumHealthyHosts())
        .map(value => zio.aws.codedeploy.model.MinimumHealthyHosts.wrap(value))
    override val trafficRoutingConfig
        : Optional[zio.aws.codedeploy.model.TrafficRoutingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficRoutingConfig())
        .map(value => zio.aws.codedeploy.model.TrafficRoutingConfig.wrap(value))
    override val computePlatform
        : Optional[zio.aws.codedeploy.model.ComputePlatform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computePlatform())
        .map(value => zio.aws.codedeploy.model.ComputePlatform.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateDeploymentConfigRequest
  ): zio.aws.codedeploy.model.CreateDeploymentConfigRequest.ReadOnly =
    new Wrapper(impl)
}
