package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.AutoScalingGroupName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TargetInstances(
    tagFilters: Optional[Iterable[zio.aws.codedeploy.model.EC2TagFilter]] =
      Optional.Absent,
    autoScalingGroups: Optional[Iterable[AutoScalingGroupName]] =
      Optional.Absent,
    ec2TagSet: Optional[zio.aws.codedeploy.model.EC2TagSet] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.TargetInstances = {
    import TargetInstances.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.TargetInstances
      .builder()
      .optionallyWith(
        tagFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagFilters)
      .optionallyWith(
        autoScalingGroups.map(value =>
          value.map { item =>
            AutoScalingGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoScalingGroups)
      .optionallyWith(ec2TagSet.map(value => value.buildAwsValue()))(
        _.ec2TagSet
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.TargetInstances.ReadOnly =
    zio.aws.codedeploy.model.TargetInstances.wrap(buildAwsValue())
}
object TargetInstances {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.TargetInstances
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.TargetInstances =
      zio.aws.codedeploy.model.TargetInstances(
        tagFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoScalingGroups.map(value => value),
        ec2TagSet.map(value => value.asEditable)
      )
    def tagFilters
        : Optional[List[zio.aws.codedeploy.model.EC2TagFilter.ReadOnly]]
    def autoScalingGroups: Optional[List[AutoScalingGroupName]]
    def ec2TagSet: Optional[zio.aws.codedeploy.model.EC2TagSet.ReadOnly]
    def getTagFilters: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.EC2TagFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("tagFilters", tagFilters)
    def getAutoScalingGroups: ZIO[Any, AwsError, List[AutoScalingGroupName]] =
      AwsError.unwrapOptionField("autoScalingGroups", autoScalingGroups)
    def getEc2TagSet
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.EC2TagSet.ReadOnly] =
      AwsError.unwrapOptionField("ec2TagSet", ec2TagSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.TargetInstances
  ) extends zio.aws.codedeploy.model.TargetInstances.ReadOnly {
    override val tagFilters
        : Optional[List[zio.aws.codedeploy.model.EC2TagFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.EC2TagFilter.wrap(item)
          }.toList
        )
    override val autoScalingGroups: Optional[List[AutoScalingGroupName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.primitives.AutoScalingGroupName(item)
          }.toList
        )
    override val ec2TagSet
        : Optional[zio.aws.codedeploy.model.EC2TagSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ec2TagSet())
        .map(value => zio.aws.codedeploy.model.EC2TagSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.TargetInstances
  ): zio.aws.codedeploy.model.TargetInstances.ReadOnly = new Wrapper(impl)
}
