package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{NextToken, GitHubAccountTokenName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListGitHubAccountTokenNamesResponse(
    tokenNameList: Optional[Iterable[GitHubAccountTokenName]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesResponse = {
    import ListGitHubAccountTokenNamesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesResponse
      .builder()
      .optionallyWith(
        tokenNameList.map(value =>
          value.map { item =>
            GitHubAccountTokenName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tokenNameList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListGitHubAccountTokenNamesResponse.ReadOnly =
    zio.aws.codedeploy.model.ListGitHubAccountTokenNamesResponse
      .wrap(buildAwsValue())
}
object ListGitHubAccountTokenNamesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codedeploy.model.ListGitHubAccountTokenNamesResponse =
      zio.aws.codedeploy.model.ListGitHubAccountTokenNamesResponse(
        tokenNameList.map(value => value),
        nextToken.map(value => value)
      )
    def tokenNameList: Optional[List[GitHubAccountTokenName]]
    def nextToken: Optional[NextToken]
    def getTokenNameList: ZIO[Any, AwsError, List[GitHubAccountTokenName]] =
      AwsError.unwrapOptionField("tokenNameList", tokenNameList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesResponse
  ) extends zio.aws.codedeploy.model.ListGitHubAccountTokenNamesResponse.ReadOnly {
    override val tokenNameList: Optional[List[GitHubAccountTokenName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tokenNameList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.primitives.GitHubAccountTokenName(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListGitHubAccountTokenNamesResponse
  ): zio.aws.codedeploy.model.ListGitHubAccountTokenNamesResponse.ReadOnly =
    new Wrapper(impl)
}
