package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{NullableBoolean, DeploymentId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopDeploymentRequest(
    deploymentId: DeploymentId,
    autoRollbackEnabled: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest = {
    import StopDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest
      .builder()
      .deploymentId(DeploymentId.unwrap(deploymentId): java.lang.String)
      .optionallyWith(
        autoRollbackEnabled.map(value => value: java.lang.Boolean)
      )(_.autoRollbackEnabled)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.StopDeploymentRequest.ReadOnly =
    zio.aws.codedeploy.model.StopDeploymentRequest.wrap(buildAwsValue())
}
object StopDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.StopDeploymentRequest =
      zio.aws.codedeploy.model.StopDeploymentRequest(
        deploymentId,
        autoRollbackEnabled.map(value => value)
      )
    def deploymentId: DeploymentId
    def autoRollbackEnabled: Optional[NullableBoolean]
    def getDeploymentId: ZIO[Any, Nothing, DeploymentId] =
      ZIO.succeed(deploymentId)
    def getAutoRollbackEnabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("autoRollbackEnabled", autoRollbackEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest
  ) extends zio.aws.codedeploy.model.StopDeploymentRequest.ReadOnly {
    override val deploymentId: DeploymentId =
      zio.aws.codedeploy.model.primitives.DeploymentId(impl.deploymentId())
    override val autoRollbackEnabled: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoRollbackEnabled())
        .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.StopDeploymentRequest
  ): zio.aws.codedeploy.model.StopDeploymentRequest.ReadOnly = new Wrapper(impl)
}
