package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.LifecycleEventHookExecutionId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutLifecycleEventHookExecutionStatusResponse(
    lifecycleEventHookExecutionId: Optional[LifecycleEventHookExecutionId] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse = {
    import PutLifecycleEventHookExecutionStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse
      .builder()
      .optionallyWith(
        lifecycleEventHookExecutionId.map(value =>
          LifecycleEventHookExecutionId.unwrap(value): java.lang.String
        )
      )(_.lifecycleEventHookExecutionId)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse.ReadOnly =
    zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse
      .wrap(buildAwsValue())
}
object PutLifecycleEventHookExecutionStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse =
      zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse(
        lifecycleEventHookExecutionId.map(value => value)
      )
    def lifecycleEventHookExecutionId: Optional[LifecycleEventHookExecutionId]
    def getLifecycleEventHookExecutionId
        : ZIO[Any, AwsError, LifecycleEventHookExecutionId] =
      AwsError.unwrapOptionField(
        "lifecycleEventHookExecutionId",
        lifecycleEventHookExecutionId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse
  ) extends zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse.ReadOnly {
    override val lifecycleEventHookExecutionId
        : Optional[LifecycleEventHookExecutionId] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecycleEventHookExecutionId())
      .map(value =>
        zio.aws.codedeploy.model.primitives.LifecycleEventHookExecutionId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse
  ): zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse.ReadOnly =
    new Wrapper(impl)
}
