package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{NextToken, DeploymentConfigName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDeploymentConfigsResponse(
    deploymentConfigsList: Optional[Iterable[DeploymentConfigName]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse = {
    import ListDeploymentConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse
      .builder()
      .optionallyWith(
        deploymentConfigsList.map(value =>
          value.map { item =>
            DeploymentConfigName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deploymentConfigsList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListDeploymentConfigsResponse.ReadOnly =
    zio.aws.codedeploy.model.ListDeploymentConfigsResponse.wrap(buildAwsValue())
}
object ListDeploymentConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListDeploymentConfigsResponse =
      zio.aws.codedeploy.model.ListDeploymentConfigsResponse(
        deploymentConfigsList.map(value => value),
        nextToken.map(value => value)
      )
    def deploymentConfigsList: Optional[List[DeploymentConfigName]]
    def nextToken: Optional[NextToken]
    def getDeploymentConfigsList
        : ZIO[Any, AwsError, List[DeploymentConfigName]] =
      AwsError.unwrapOptionField("deploymentConfigsList", deploymentConfigsList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse
  ) extends zio.aws.codedeploy.model.ListDeploymentConfigsResponse.ReadOnly {
    override val deploymentConfigsList: Optional[List[DeploymentConfigName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentConfigsList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.primitives.DeploymentConfigName(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse
  ): zio.aws.codedeploy.model.ListDeploymentConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
