package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Iterable[zio.aws.codedeploy.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.TagResourceRequest.ReadOnly =
    zio.aws.codedeploy.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.TagResourceRequest =
      zio.aws.codedeploy.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: Arn
    def tags: List[zio.aws.codedeploy.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.codedeploy.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.TagResourceRequest
  ) extends zio.aws.codedeploy.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.codedeploy.model.primitives.Arn(impl.resourceArn())
    override val tags: List[zio.aws.codedeploy.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.codedeploy.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.TagResourceRequest
  ): zio.aws.codedeploy.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
