package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.DeploymentId
import scala.jdk.CollectionConverters._
final case class GetDeploymentRequest(deploymentId: DeploymentId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest = {
    import GetDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest
      .builder()
      .deploymentId(DeploymentId.unwrap(deploymentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.GetDeploymentRequest.ReadOnly =
    zio.aws.codedeploy.model.GetDeploymentRequest.wrap(buildAwsValue())
}
object GetDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetDeploymentRequest =
      zio.aws.codedeploy.model.GetDeploymentRequest(deploymentId)
    def deploymentId: DeploymentId
    def getDeploymentId: ZIO[Any, Nothing, DeploymentId] =
      ZIO.succeed(deploymentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest
  ) extends zio.aws.codedeploy.model.GetDeploymentRequest.ReadOnly {
    override val deploymentId: DeploymentId =
      zio.aws.codedeploy.model.primitives.DeploymentId(impl.deploymentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest
  ): zio.aws.codedeploy.model.GetDeploymentRequest.ReadOnly = new Wrapper(impl)
}
