package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeploymentStyle(
    deploymentType: Optional[zio.aws.codedeploy.model.DeploymentType] =
      Optional.Absent,
    deploymentOption: Optional[zio.aws.codedeploy.model.DeploymentOption] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeploymentStyle = {
    import DeploymentStyle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeploymentStyle
      .builder()
      .optionallyWith(deploymentType.map(value => value.unwrap))(
        _.deploymentType
      )
      .optionallyWith(deploymentOption.map(value => value.unwrap))(
        _.deploymentOption
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.DeploymentStyle.ReadOnly =
    zio.aws.codedeploy.model.DeploymentStyle.wrap(buildAwsValue())
}
object DeploymentStyle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeploymentStyle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.DeploymentStyle =
      zio.aws.codedeploy.model.DeploymentStyle(
        deploymentType.map(value => value),
        deploymentOption.map(value => value)
      )
    def deploymentType: Optional[zio.aws.codedeploy.model.DeploymentType]
    def deploymentOption: Optional[zio.aws.codedeploy.model.DeploymentOption]
    def getDeploymentType
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.DeploymentType] =
      AwsError.unwrapOptionField("deploymentType", deploymentType)
    def getDeploymentOption
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.DeploymentOption] =
      AwsError.unwrapOptionField("deploymentOption", deploymentOption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentStyle
  ) extends zio.aws.codedeploy.model.DeploymentStyle.ReadOnly {
    override val deploymentType
        : Optional[zio.aws.codedeploy.model.DeploymentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentType())
        .map(value => zio.aws.codedeploy.model.DeploymentType.wrap(value))
    override val deploymentOption
        : Optional[zio.aws.codedeploy.model.DeploymentOption] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentOption())
        .map(value => zio.aws.codedeploy.model.DeploymentOption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentStyle
  ): zio.aws.codedeploy.model.DeploymentStyle.ReadOnly = new Wrapper(impl)
}
