package zio.aws.codedeploy.model
import zio.prelude.data.Optional
import zio.aws.codedeploy.model.primitives.Duration
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class BlueInstanceTerminationOption(
    action: Optional[zio.aws.codedeploy.model.InstanceAction] = Optional.Absent,
    terminationWaitTimeInMinutes: Optional[Duration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BlueInstanceTerminationOption = {
    import BlueInstanceTerminationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BlueInstanceTerminationOption
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        terminationWaitTimeInMinutes.map(value =>
          Duration.unwrap(value): Integer
        )
      )(_.terminationWaitTimeInMinutes)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.BlueInstanceTerminationOption.ReadOnly =
    zio.aws.codedeploy.model.BlueInstanceTerminationOption.wrap(buildAwsValue())
}
object BlueInstanceTerminationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BlueInstanceTerminationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.BlueInstanceTerminationOption =
      zio.aws.codedeploy.model.BlueInstanceTerminationOption(
        action.map(value => value),
        terminationWaitTimeInMinutes.map(value => value)
      )
    def action: Optional[zio.aws.codedeploy.model.InstanceAction]
    def terminationWaitTimeInMinutes: Optional[Duration]
    def getAction: ZIO[Any, AwsError, zio.aws.codedeploy.model.InstanceAction] =
      AwsError.unwrapOptionField("action", action)
    def getTerminationWaitTimeInMinutes: ZIO[Any, AwsError, Duration] =
      AwsError.unwrapOptionField(
        "terminationWaitTimeInMinutes",
        terminationWaitTimeInMinutes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BlueInstanceTerminationOption
  ) extends zio.aws.codedeploy.model.BlueInstanceTerminationOption.ReadOnly {
    override val action: Optional[zio.aws.codedeploy.model.InstanceAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.codedeploy.model.InstanceAction.wrap(value))
    override val terminationWaitTimeInMinutes: Optional[Duration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminationWaitTimeInMinutes())
        .map(value => zio.aws.codedeploy.model.primitives.Duration(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BlueInstanceTerminationOption
  ): zio.aws.codedeploy.model.BlueInstanceTerminationOption.ReadOnly =
    new Wrapper(impl)
}
